#!/usr/bin/perl

# home.cgi - a Web interface for managing MyLibrary terms

# Eric Lease Morgan <emorgan@nd.edu>

# 2004-10-29 - first cut


# require the necessary modules
use CGI qw/:standard/;
use CGI::Carp qw(fatalsToBrowser);
use strict;
require 'subroutines.pl';

# initialize two global variables
my $cgi = CGI->new;

# output the 'magic line', a standard header, the content, and a standard footer, then done
print $cgi->header;
print &header;
print $cgi->h1('Musings administration');
print $cgi->p("I use this system to manage 'Musings on Information and Librarianship'.");
print &footer;
exit;



sub header {

	# get the value of this script
	my $script = $cgi->script_name;
	
	# return a standard html page; notice the stylesheet
	return <<EOH;
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<title>Musings administration</title>
		<link rel='stylesheet' href='style.css' type='text/css' />
	</head>
	<body>
		<div id="navcontainer">
			<ul id="navlist">
				<li><a href="home.cgi" id="current">Home</a></li>
				<li><a href="authors.cgi">Authors</a></li>
				<li><a href="subjects.cgi">Subjects</a></li>
				<li><a href="templates.cgi">Templates</a></li>
				<li><a href="stylesheets.cgi">Stylesheets</a></li>
				<li><a href="articles.cgi">Articles</a></li>
			</ul>
		</div>
	
	<div class='menu'>
	<br />
	<br />
	<br />
	<br />
	<br />
	<br />
	<br />
	<br />
	</div>
	<div class='content'>
EOH

}
