#!/usr/bin/perl

# marc2marcxml.pl - creates individual MARCXML files from MARC records
#                   the program assumes the MARC records have a .marc
#                   filename extension and each record has a unique
#                   value in field 099 subfield a

# Eric Lease Morgan <eric_morgan@infomotions.com>
# May 29, 2004


# use the necessary modules
use File::Basename;
use File::Find;
use MARC::Batch;
use MARC::File::XML;
use strict;

# get the input
my $in  = shift @ARGV;
my $out = shift @ARGV;

# check for input
if (! $in or ! $out) {

	# print help text and quit
	print "Usage: $0 [full path to input directory] [full path to output directory]\n";
	exit;
	
}

# process every file in the defined directory
find (\&process_files, $in);

# done
exit;


# process each found file
sub process_files {

	# get the name of the found file
	my $file = $File::Find::name;
	
	# make sure it has the correct extension
	next if ($file !~ m/\.marc$/);

	# open the file, as it were
	my $batch = MARC::Batch->new('USMARC', $file);

	# process every record in the batch
	while (my $record = $batch->next()) { 
	
		# define the output file name
		my $outfile = $record->field('099', 'a');
		$outfile = $out . '/'. $outfile->as_string . '.xml';
		
		# the heart of the matter
		print "Processing $outfile...\n";
		open (OUT, "> $outfile");
		binmode (OUT, ':utf8');
		print OUT MARC::File::XML::header;
		print OUT MARC::File::XML::record($record);
		print OUT MARC::File::XML::footer;
		close OUT;
		
	}
			
}
		