# marc-read.pl - a Perl script to read various fields of a batch of MARC records

# Eric Lease Morgan (emorgan@nd.edu)
# September 1, 2003 - Labor Day

# based on Example #2 of the MARC::Doc::Tutoral

# get the input
my $marc_records = shift @ARGV;

# check for input
if (! $marc_records) {

	# print help text and quit
	print "Usage: marc-list.pl [file] where [file] is the name of a file containing USMARC records.\n";
	exit;
	
}

# use the necessary module
use MARC::Batch;

# create a batch object with the input file
my $batch = MARC::Batch->new('USMARC', $marc_records);

# process every record in the object
while (my $record = $batch->next()) {
	
	# extract the desired data
	my $author   = $record->subfield('100', 'a');
	my $title    = $record->subfield('245', 'a');
	my @subjects = $record->field('650'); 
		
	# print the author and title
	print "   author: $author\n";
	print "    title: $title\n";
	
	# process each subject
	foreach my $subject (@subjects) {
	
		# print the subject
		print "  subject: " . $subject->as_string(). "\n";
	
	}
	
	# make things a bit pretty
	print "\n";
	
} 

# done
exit;
