#!/usr/bin/perl

# rss.cgi - output an RSS feed of resources via javascript

# Eric Lease Morgan <emorgan@nd.edu>
# February 22, 2006

# require/use
use lib '../lib/';
use CGI;
use CGI::Carp qw(fatalsToBrowser);
use MyLibrary::Core;
use strict;

# let's get started
my $cgi = CGI->new;
my $rss = '<rss version="2.0"><channel>';

# branch accordingly
if ($cgi->param('pid')) {

	# create a patron based on the id
	my $patron = MyLibrary::Patron->new(id => $cgi->param('pid'));
	
	# start the rss
	$rss .= '<title>My MyLibrary Page</title>';
	$rss .= '<link>http://dewey.library.nd.edu/morgan/zagreb/?cmd=patron&amp;id=' . $cgi->param('pid') . '</link>';
	$rss .= '<description>This is my personalized MyLibrary page</description>';
	
	# create a resource list
	my @resource_ids = $patron->patron_resources(sort => 'name');
	
	# build the list
	foreach my $resource_id (@resource_ids) {
	
		# get this resource
		my $resource = MyLibrary::Resource->new(id => $resource_id);
		
		# get the url; dumb!
		my @locations = $resource->resource_locations;
		my $location;
		foreach ( @locations ) { $location = $_->location }
		
		# build the feed
		$rss .= '<item>';
		$rss .= '<title>'       . &escape($resource->name) . '</title>';
		$rss .= '<link>'        . &escape($location)       . '</link>';
		$rss .= '<description>' . &escape($resource->note) . '</description>';
		$rss .= '</item>';
		
	}
	
}

elsif ($cgi->param('tid')) {

	# create the region term
	my $term = MyLibrary::Term->new(id => $cgi->param('tid'));
	
	# start the rss
	$rss .= '<title>Recommended resources for ' . $term->term_name . '</title>';
	$rss .= '<link>http://dewey.library.nd.edu/morgan/zagreb/?cmd=term&amp;id=' . $cgi->param('tid') . '</link>';
	$rss .= '<description>Use the recommended resources to get started with your research.</description>';

	# get a list of all resources associated wiht this term
	my @resource_ids = $term->suggested_resources (sort => 'name');
	
	# build the list
	foreach my $resource_id (@resource_ids) {
	
		# get this resource
		my $resource = MyLibrary::Resource->new(id => $resource_id);
		
		# get the url; dumb!
		my @locations = $resource->resource_locations;
		my $location;
		foreach ( @locations ) { $location = $_->location }
		
		# build the feed
		$rss .= '<item>';
		$rss .= '<title>'       . &escape($resource->name) . '</title>';
		$rss .= '<link>'        . &escape($location)       . '</link>';
		$rss .= '<description>' . &escape($resource->note) . '</description>';
		$rss .= '</item>';
		
	}

}

# close the rss
print $cgi->header(-type => 'text/xml', -charset => 'utf-8');
$rss .= '</channel></rss>';

print $rss;


sub escape {

    my $text = shift;
    $text =~ s/&/&amp;/g;
    $text =~ s/</&lt;/g;
    $text =~ s/>/&gt;/g;
    return($text);
    
}


