#!/usr/bin/perl

# ol.cgi - output an ordered list of resources via javascript

# Eric Lease Morgan <emorgan@nd.edu>
# February 22, 2006

# require/use
use lib '../lib/';
use CGI;
use CGI::Carp qw(fatalsToBrowser);
use MyLibrary::Core;
use strict;

# let's get started
my $cgi = CGI->new;
print $cgi->header(-type => 'text/javascript', -charset => 'utf-8');

# branch accordingly
if ($cgi->param('pid')) {

	# create a patron based on the id
	my $patron = MyLibrary::Patron->new(id => $cgi->param('pid'));
	
	# create a resource list
	my $resource_list;
	my @resource_ids = $patron->patron_resources(sort => 'name');
	
	# build the list
	foreach my $resource_id (@resource_ids) {
	
		# get this resource
		my $resource = MyLibrary::Resource->new(id => $resource_id);
		
		# get the url; dumb!
		my @locations = $resource->resource_locations;
		my $location;
		foreach ( @locations ) { $location = $_->location }
		
		# build a list
		$resource_list .= $cgi->li($cgi->a({-href => $location}, &escape($resource->name)) . ' - ' . &escape($resource->note));

	}

	# finish up; escape single quotes;
	$resource_list =~ s/'/\\'/g;
	$resource_list = $cgi->ol($resource_list);
	
	# done; wrap the output in a javascript command
	&jswrite (qq(document.write ('<div class="patron_resources">$resource_list</div>')));

}

elsif ($cgi->param('tid')) {

	# create the region term
	my $term = MyLibrary::Term->new(id => $cgi->param('tid'));
	
	# get a list of all resources associated wiht this term
	my $resource_list;
	my @resource_ids = $term->suggested_resources (sort => 'name');
	
	# build the list
	foreach my $resource_id (@resource_ids) {
	
		# get this resource
		my $resource = MyLibrary::Resource->new(id => $resource_id);
		
		# get the url; dumb!
		my @locations = $resource->resource_locations;
		my $location;
		foreach ( @locations ) { $location = $_->location }
		
		# build a list
		$resource_list .= $cgi->li($cgi->a({-href => $location}, &escape($resource->name)) . ' - ' . &escape($resource->note));

	}

	# finish up; escape single quotes;
	$resource_list =~ s/'/\\'/g;
	$resource_list = $cgi->ol($resource_list);
	
	# done; wrap the output in a javascript command
	&jswrite (qq(document.write ('<div class="term_resources">$resource_list</div>')));

}

else {

	&jswrite (qq(document.write ('<div><p>Invalid input.</p></div>')));

}


sub jswrite {

	my $s = $_[0];
	print qq($s);
	print "\n";
	
}

sub escape {

    my $text = shift;
    $text =~ s/&/&amp;/g;
    $text =~ s/</&lt;/g;
    $text =~ s/>/&gt;/g;
    return($text);
    
}

