#!/usr/bin/perl

# portal2swish.pl - send to STDOUT an XML stream swish-e can index

# Eric Lease Morgan <emorgan@nd.edu>
# January 31, 2006 - getting ready for a distro; added pod


=head1 NAME

portal2swish.pl -  send to STDOUT an XML stream swish-e can index


=head1 SYNOPSIS

portal2swish.pl


=head1 DESCRIPTION

The purpose of this script is to send to STDOUT a stream of XML that swish-e can index. It is intended to be used in conjunction with the MyLibrary Perl modules.

The script will data about every information resource in your MyLibrary instance to STDOUT. As it is currently written, it will only output title, location (URL), description, fkey, id, and associated terms. Use this script as a framework for indexing additional fields or subsets of your MyLibrary instance.

As long as MyLibrary::Core is in your Perl path, then no configuration should be necessary.


=head1 AUTHOR

Eric Lease Morgan

=cut


use lib '/usr/local/apache/htdocs/morgan/zagreb/lib';
use MyLibrary::Core;
use strict;

# get all the resource ids
my @resource_ids = MyLibrary::Resource->get_resources(output => 'id');

# process each resoruce
foreach (@resource_ids) {

	my $resource = MyLibrary::Resource->new(id => $_);
	my $record = asXML($resource);
	my $docId = $resource->id;
	my $length = length( $record );
	print "Path-Name: $docId\nContent-Length: $length\n\n$record";
	
}


sub asXML {

	# get the input
	my $r = shift;
	
	# extract what i need
	my $title = $r->name, "\n";
	my $url; foreach ($r->resource_locations) { $url = $_->location }
	my $subjects = $r->subject;
	my $creator = $r->creator;
	my $description = $r->note;
	my $fkey = $r->fkey;
	my $identifier = $r->id;
	my @term_ids = $r->related_terms;
	my $terms = '';
	foreach (@term_ids) {
	
		my $term = MyLibrary::Term->new(id => $_);
		$terms .= $term->term_name . '; ';
		
	}

	# create a report
	return <<EOR;
<record>
	<title>$title</title>
	<url>$url</url>
	<subjects>$subjects</subjects>
	<creator>$creator</creator>
	<description>$description</description>
	<fkey>$fkey</fkey>
	<terms>$terms</terms>
</record>
EOR
		
	}
