#!/usr/bin/perl

# xsltproc.cgi - CGI interface to tranform XML file using an XSLT file

# Eric Lease Morgan <eric_morgan@infomotions.com>

# July 7, 2004 - Getting ready for LAMP 'n Monterey


######################################################
# no configuration should be necessary below this line

# require the necessary modules
use CGI qw(:standard);
use CGI::Carp qw(fatalsToBrowser);
use strict;
use XML::LibXML;
use XML::LibXSLT;

# initalize CGI I/O
my $input  = new CGI;
my $output = new CGI("");

# get input
my $xslt_file = $input->param('xslt');
my $xml_file  = $input->param('xml');

# check for input
if (! $xslt_file || ! $xml_file) {

	print header, start_html('xsltproc.cgi'), h1("Oops!"), p("No input."), end_html;
	exit;

}

# initialize
my $parser = XML::LibXML->new;
my $xslt   = XML::LibXSLT->new;

# parse the input files
my $style = $parser->parse_file($xslt_file);
my $doc   = $parser->parse_file($xml_file);

# validate stylesheet
my $stylesheet = $xslt->parse_stylesheet($style);

# transform the source file
my $results = $stylesheet->transform($doc);

# send the HTTP "magic line"
print header;

# send the transformed document to STOUT
print $stylesheet->output_string($results);

# done
exit;
