#!/usr/bin/perl

# tags2gallery.pl - create index.html files from tags flickr content

# Eric Lease Morgan <eric_morgan@infomotions.com>
# May 17, 2010 - first investigations


# require
use CGI;
use LWP::UserAgent;
use strict;
use XML::XPath;

# configure
use constant GETLISTUSERPOPULAR => 'http://api.flickr.com/services/rest/?method=flickr.tags.getListUserPopular&api_key=50e083708380c01d75fb123fec320365&count=100&user_id=94959848@N00';
use constant FLICKRPHOTOSSEARCH => 'http://api.flickr.com/services/rest/?method=flickr.photos.search&api_key=50e083708380c01d75fb123fec320365&user_id=94959848@N00&tags=';
use constant FLICKR             => 'http://www.flickr.com/photos/infomotions/';
use constant ROOT               => '/disk01/www/html/main/images/';

# get my tags
my $ua          = LWP::UserAgent->new;
my $request     = HTTP::Request->new( GET => GETLISTUSERPOPULAR );
my $response    = $ua->request( $request );

# build a list of all tags
my $parser = XML::XPath->new( xml => $response->content );
my $nodes  = $parser->find( '//tag' );
my %tags   = ();
foreach my $node ( $nodes->get_nodelist ) { $tags{ $node->string_value } = $node->getAttribute( 'count' ) }

# process each tag
foreach ( keys %tags ) {

	my $tag   = $_;
	my $count = $tags{ $tag };
	print "Processing $tag ($count items)...\n";
	
	# find photos with this tag
	$request     = HTTP::Request->new( GET => FLICKRPHOTOSSEARCH . $tag );
	$response    = $ua->request( $request );
	
	# process each photo
	$parser    = XML::XPath->new( xml => $response->content );
	$nodes     = $parser->find( '//photo' );
	my $cgi    = CGI->new;
	my $images = '';
	foreach my $node ( $nodes->get_nodelist ) {
	
		# parse
		my $id     = $node->getAttribute( 'id' );
		my $title  = $node->getAttribute( 'title' );
		my $farm   = $node->getAttribute( 'farm' );
		my $server = $node->getAttribute( 'server' );
		my $secret = $node->getAttribute( 'secret' );
	
		# build image links
		my $thumb = "http://farm$farm.static.flickr.com/$server/$id" . '_' . $secret . '_s.jpg';
		my $full  = "http://farm$farm.static.flickr.com/$server/$id" . '_' . $secret . '.jpg';
		my $flickr = FLICKR . "$id/";
		
		# build list of images
		$images .= $cgi->a({ href => $full, rel => 'slideshow', title => "<a href='$flickr'>Details on Flickr</a>"}, $cgi->img({ alt => $title, src => $thumb, border => 0, hspace => 1, vspace => 1 }));
		
	}
	
	# build html
	my $html =  &template;
	$html    =~ s/##TITLE##/$tag/;
	$html    =~ s/##IMAGES##/$images/;
	$html    =~ s/##DIRECTORY##/$tag/eg;
	
	# save
	my $directory = ROOT . $tag;
	mkdir $directory;
	my $index = "$directory/index.html";
	open OUT, " > " . $index or die "Can't open $index: $!\n";
	print OUT $html;
	close OUT;

}

# done
exit;


sub template {

	# shape of html page
	return <<EOF
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
        "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<link rel="stylesheet" type="text/css" href="http://infomotions.com/etc/css/jquery-ui.css" />
	<link rel="stylesheet" type="text/css" href="http://infomotions.com/etc/css/screen.css" media="screen" />
	<link rel="stylesheet" type="text/css" href="http://infomotions.com/etc/css/print.css" media="print" />
	<link rel="stylesheet" type="text/css" href="/etc/colorbox/colorbox.css" media="screen" />
	<script type="text/javascript" src="/etc/js/jquery-core.js"></script>
	<script type="text/javascript" src="/etc/colorbox/colorbox.js"></script>
	<script type="text/javascript">
		\$(document).ready(function(){
			\$("a[rel='slideshow']").colorbox({ slideshowAuto: false, current: "{current} of {total}", slideshowStart: 'Slideshow', slideshowStop: 'Stop', slideshow: true, transition:"elastic"});
		});
	</script>
	<title>Infomotions, Inc.</title>
</head>
<body>

	<!-- global navigation; menu bar -->
	<div id="menu" class="ui-tabs ui-widget ui-widget-content ui-corner-all">
		
			<ul id="tabs" class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">
				<li id='first-tab' class="ui-state-default ui-corner-top"><a href="/">Home</a>
				<li class="ui-state-default ui-corner-top"><a href="/alex/">Alex Catalogue</a>
				<li class="ui-state-default ui-corner-top ui-tabs-selected ui-state-active"><a href="/images/">Images</a>
				<li class="ui-state-default ui-corner-top"><a href="/blog/">Blog</a>
				<li class="ui-state-default ui-corner-top"><a href="/musings/">Musings</a>
				<li class="ui-state-default ui-corner-top"><a href="/water/index.xml">Water</a>
				<li class="ui-state-default ui-corner-top"><a href="http://m.infomotions.com/">iMobile</a>
			</ul>
				
	</div>
		
	<!-- navigation -->
	<div id='navigation'>
		<div class='innertube'>
		
                <!-- logo and short -->
                <p id='navigation-logo'><img src='/logo.gif' width="44" height="44" alt='logo' /><br />
                <br />Image Gallery</p>
                
		</div>
	</div>
        
	<!-- content -->
	<div id='content'>
		<div class='innertube'>
		<h2>##TITLE##</h2>
				
		<p>##IMAGES##</p>
		
		<hr />
		<p>Creator: Eric Lease Morgan &lt;<a href="mailto:eric_morgan\@infomotions.com">eric_morgan\@infomotions.com</a>&gt;<br />
		Date created: 2001-01-01<br />
		Date updated: 2010-05-22<br />
		URL: <a href="http://infomotions.com/images/##DIRECTORY##/">http://infomotions.com/images/##DIRECTORY##/</a></p>
		</div>
	</div>
</body>
</html>
EOF

}