#!/usr/bin/perl

# get-mbooks.pl - get a bunch of MBooks OAI records and save them to a file

# Eric Lease Morgan <emorgan@nd.edu>
# December 15, 2007 - tweaked for Karen Coyle
# December 15, 2007 - added set spec and binmode; got all records
# December 14, 2007 - Thanks Ed!


# require/include
use lib './lib';
use Net::OAI::Harvester;
use strict;

# define how the harvester works; you probably don't want to change these
use constant OAIURL  => 'http://quod.lib.umich.edu/cgi/o/oai/oai';
use constant PREFIX  => 'marc21';
use constant HANDLER => 'MARC::File::SAX';
use constant SET     => 'mbooks:pd';

# get out_file and sanity check
my $out_file = $ARGV[ 0 ];
if ( ! $out_file ) {

	print "\n";
	print "    Usage: $0 <file> where <file> is your desired output file\n";
	print "  Example: $0 ./mbooks.marc\n";
	print "\n";
	exit;

}

# initialize
$| = 1;
my $harvester =  Net::OAI::Harvester->new( baseURL => OAIURL );
open OUT, ' > ' . $out_file or die "Can't open output: $!\n";
binmode OUT, 'utf8';

# get a bunch o' records
my $response  = $harvester->listAllRecords(

	metadataPrefix  => PREFIX,
	metadataHandler => HANDLER,
	set             => SET

);

# process each record
my $index = 0;
while ( my $record = $response->next ) { 

	# save it to a file
	$index++;
	print "Processing record $index\r";
	print OUT $record->metadata()->record()->as_usmarc
	
}

# clean up
print "\nDone\n";
close OUT;
exit;
