#!/usr/bin/perl

# c4lj2doaj.cgi - query code4lib journal (wordpress) database and create doajaxml

# Eric Lease Morgan <emorgan@nd.edu>
# May 28, 2008 - added startPage and publisherRecordId to XML template
# May 24, 2008 - first cut

# require
use lib '../lib';
use C4LJ::Article;
use CGI;
use strict;

# initialize
my $records = '';
my $cgi = CGI->new;
my $issue = $cgi->param( 'issue' );

# (weak) sanity check
if ( $issue !~ /\d+/ ) {

	print $cgi->header;
	my $html = $cgi->start_html( 'c4lj2doaj.cgi' );
	$html .= $cgi->h1({ -style => 'text-align: center' }, 'Error' );
	$html .= $cgi->p({ -style => 'text-align: center' }, "You need to supply an issue number (ex: " . $cgi->a({ href => 'http://infomotions.com/C4LJ/c4lj2doaj.cgi?issue=1' }, "http://infomotions.com/C4LJ/c4lj2doaj.cgi?issue=1)" ));
	$html .= $cgi->end_html;
	print $html;
	exit;
	      
}

# process each article
foreach my $article ( C4LJ::Article->get_articles( issue => $issue )) {

	# slurp up the template and process the macros
	my $record = &template;
	$record =~ s/##ID##/&escape_entities($article->id)/e;
	$record =~ s/##TITLE##/&escape_entities($article->title)/e;
	$record =~ s/##ABSTRACT##/&escape_entities($article->abstract)/e;
	$record =~ s/##AUTHOR##/&escape_entities($article->author)/e;
	$record =~ s/##URL##/&escape_entities($article->url)/e;
	$record =~ s/##DATE##/&escape_entities($article->date)/e;
	$record =~ s/##ISSUE##/&escape_entities($article->issue)/e;
	
	# add the records to the list of records
	$records .= $record;
	
}

# done
print $cgi->header(-type=>'text/xml', -charset => 'UTF-8');
print <<XML;
<?xml version="1.0" encoding="UTF-8"?>
<records>
$records</records>
XML
exit;

sub template {

	return <<EOT;
  <record>
    <language>eng</language>
    <publisher>Code4Lib</publisher>
    <journalTitle>Code4Lib Journal</journalTitle>
    <issn>19405758</issn>
    <publicationDate>##DATE##</publicationDate>
    <issue>##ISSUE##</issue>
    <documentType>article</documentType>
    <startPage>##ID##</startPage>
    <publisherRecordId>##ID##</publisherRecordId>
    <title language="eng">##TITLE##</title>
    <authors>
      <author>
        <name>##AUTHOR##</name>
      </author>
    </authors>
    <abstract language="eng">##ABSTRACT##</abstract>
    <fullTextUrl format="html">##URL##</fullTextUrl>
  </record>
EOT

}

sub escape_entities {

	# get the input
	my $s = shift;
	
	# escape
	$s =~ s/&/&amp;/g;
	$s =~ s/</&lt;/g;
	$s =~ s/>/&gt;/g;
	$s =~ s/"/&quot;/g;
	$s =~ s/'/&apos;/g;

	# done
	return $s;
	
}

